<?php
/**
 * Plugin Name: カスタムアフィリエイトリンク
 * Plugin URI: https://example.com
 * Description: Cocoon風のAmazon/楽天/Yahoo/DMMアフィリエイトリンクを簡単に作成
 * Version: 2.0.0
 * Author: Your Name
 * License: GPL2
 */

// セキュリティ: 直接アクセスを防ぐ
if (!defined('ABSPATH')) {
    exit;
}

// 管理画面メニューを追加
add_action('admin_menu', 'cal_add_admin_menu');
function cal_add_admin_menu() {
    add_options_page(
        'カスタムアフィリエイトリンク設定',
        'アフィリエイト設定',
        'manage_options',
        'custom-affiliate-links',
        'cal_settings_page'
    );
}

// 設定ページの表示
function cal_settings_page() {
    ?>
    <div class="wrap">
        <h1>カスタムアフィリエイトリンク設定</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('cal_settings_group');
            do_settings_sections('custom-affiliate-links');
            submit_button();
            ?>
        </form>
        
        <div style="margin-top: 30px; padding: 20px; background: #f0f0f1; border-left: 4px solid #2271b1;">
            <h2>使い方</h2>
            <p>記事内で以下のショートコードを使用してください：</p>
            <pre style="background: white; padding: 10px; border: 1px solid #ddd;">[affiliate_link asin="B081VR349C" kw="商品名"]</pre>
            
            <h3>Cocoonからの移行</h3>
            <p>Cocoonの <code>[amazon]</code> ショートコードを一括置換で移行できます：</p>
            <ol>
                <li>「ツール」→「Search Regex」などの一括置換プラグインを使用</li>
                <li>検索: <code>[amazon</code></li>
                <li>置換: <code>[affiliate_link</code></li>
                <li>「すべて置換」を実行</li>
            </ol>
            
            <h3>オプション</h3>
            <ul>
                <li><strong>asin</strong> (必須): Amazon ASIN</li>
                <li><strong>kw</strong> (必須): 商品名・キーワード</li>
                <li><strong>amazon</strong> (省略可): 0でAmazonボタン非表示</li>
                <li><strong>rakuten</strong> (省略可): 0で楽天ボタン非表示</li>
                <li><strong>yahoo</strong> (省略可): 0でYahoo!ボタン非表示</li>
                <li><strong>dmm</strong> (省略可): 0でDMMボタン非表示</li>
                <li><strong>mercari</strong> (省略可): 0でメルカリボタン非表示</li>
            </ul>
            <h3>例</h3>
            <pre style="background: white; padding: 10px; border: 1px solid #ddd;">[affiliate_link asin="4778323238" kw="愛蔵版 国民クイズ 上"]
[affiliate_link asin="B081VR349C" kw="iRobot ルンバ" rakuten="0" yahoo="0"]</pre>
        </div>
    </div>
    <?php
}

// 設定の登録
add_action('admin_init', 'cal_register_settings');
function cal_register_settings() {
    register_setting('cal_settings_group', 'cal_amazon_associate_id');
    register_setting('cal_settings_group', 'cal_rakuten_affiliate_id');
    register_setting('cal_settings_group', 'cal_yahoo_sid');
    register_setting('cal_settings_group', 'cal_yahoo_pid');
    register_setting('cal_settings_group', 'cal_dmm_affiliate_id');
    register_setting('cal_settings_group', 'cal_mercari_ambassador_id');
    register_setting('cal_settings_group', 'cal_default_show_amazon');
    register_setting('cal_settings_group', 'cal_default_show_rakuten');
    register_setting('cal_settings_group', 'cal_default_show_yahoo');
    register_setting('cal_settings_group', 'cal_default_show_dmm');
    register_setting('cal_settings_group', 'cal_default_show_mercari');
    
    add_settings_section(
        'cal_main_section',
        'アフィリエイトID設定',
        'cal_section_callback',
        'custom-affiliate-links'
    );
    
    add_settings_field(
        'cal_amazon_associate_id',
        'AmazonアソシエイトID',
        'cal_amazon_field_callback',
        'custom-affiliate-links',
        'cal_main_section'
    );
    
    add_settings_field(
        'cal_rakuten_affiliate_id',
        '楽天アフィリエイトID',
        'cal_rakuten_field_callback',
        'custom-affiliate-links',
        'cal_main_section'
    );
    
    add_settings_field(
        'cal_yahoo_settings',
        'Yahoo!ショッピング設定',
        'cal_yahoo_field_callback',
        'custom-affiliate-links',
        'cal_main_section'
    );
    
    add_settings_field(
        'cal_dmm_affiliate_id',
        'DMMアフィリエイトID',
        'cal_dmm_field_callback',
        'custom-affiliate-links',
        'cal_main_section'
    );
    
    add_settings_field(
        'cal_mercari_ambassador_id',
        'メルカリアンバサダーID',
        'cal_mercari_field_callback',
        'custom-affiliate-links',
        'cal_main_section'
    );
    
    add_settings_section(
        'cal_display_section',
        'デフォルト表示設定',
        'cal_display_section_callback',
        'custom-affiliate-links'
    );
    
    add_settings_field(
        'cal_default_display',
        '表示するボタン',
        'cal_default_display_callback',
        'custom-affiliate-links',
        'cal_display_section'
    );
}

function cal_section_callback() {
    echo '<p>各アフィリエイトサービスのIDを入力してください。</p>';
}

function cal_display_section_callback() {
    echo '<p>デフォルトで表示するボタンを選択してください。個別記事でショートコードのパラメータで上書き可能です。</p>';
}

function cal_amazon_field_callback() {
    $value = get_option('cal_amazon_associate_id', '');
    echo '<input type="text" name="cal_amazon_associate_id" value="' . esc_attr($value) . '" class="regular-text" placeholder="例: yourtag-22">';
    echo '<p class="description">AmazonアソシエイトのトラッキングID</p>';
}

function cal_rakuten_field_callback() {
    $value = get_option('cal_rakuten_affiliate_id', '');
    echo '<input type="text" name="cal_rakuten_affiliate_id" value="' . esc_attr($value) . '" class="regular-text" placeholder="使用しません（検索リンクのみ）" disabled>';
    echo '<p class="description">※ 楽天は検索リンクのみ対応（アフィリエイトIDは使用しません）</p>';
}

function cal_yahoo_field_callback() {
    $sid = get_option('cal_yahoo_sid', '');
    $pid = get_option('cal_yahoo_pid', '');
    echo '<label>バリューコマースsid:</label><br>';
    echo '<input type="text" name="cal_yahoo_sid" value="' . esc_attr($sid) . '" class="regular-text" placeholder="例: 3540346"><br>';
    echo '<label style="margin-top: 10px; display: inline-block;">バリューコマースpid:</label><br>';
    echo '<input type="text" name="cal_yahoo_pid" value="' . esc_attr($pid) . '" class="regular-text" placeholder="例: 886637566">';
    echo '<p class="description">バリューコマースでYahoo!ショッピングと提携後、sidとpidを取得</p>';
}

function cal_dmm_field_callback() {
    $value = get_option('cal_dmm_affiliate_id', '');
    echo '<input type="text" name="cal_dmm_affiliate_id" value="' . esc_attr($value) . '" class="regular-text" placeholder="例: takehana-001">';
    echo '<p class="description">DMMアフィリエイトID</p>';
}

function cal_mercari_field_callback() {
    $value = get_option('cal_mercari_ambassador_id', '');
    echo '<input type="text" name="cal_mercari_ambassador_id" value="' . esc_attr($value) . '" class="regular-text" placeholder="例: 5238199015">';
    echo '<p class="description">メルカリアンバサダーID（10桁の数字）</p>';
}

function cal_default_display_callback() {
    $show_amazon = get_option('cal_default_show_amazon', '1');
    $show_rakuten = get_option('cal_default_show_rakuten', '1');
    $show_yahoo = get_option('cal_default_show_yahoo', '1');
    $show_dmm = get_option('cal_default_show_dmm', '1');
    $show_mercari = get_option('cal_default_show_mercari', '1');
    
    echo '<label><input type="checkbox" name="cal_default_show_amazon" value="1" ' . checked($show_amazon, '1', false) . '> Amazon</label><br>';
    echo '<label><input type="checkbox" name="cal_default_show_rakuten" value="1" ' . checked($show_rakuten, '1', false) . '> 楽天市場</label><br>';
    echo '<label><input type="checkbox" name="cal_default_show_yahoo" value="1" ' . checked($show_yahoo, '1', false) . '> Yahoo!ショッピング</label><br>';
    echo '<label><input type="checkbox" name="cal_default_show_dmm" value="1" ' . checked($show_dmm, '1', false) . '> DMM</label><br>';
    echo '<label><input type="checkbox" name="cal_default_show_mercari" value="1" ' . checked($show_mercari, '1', false) . '> メルカリ</label>';
}

// ショートコードの登録
add_shortcode('affiliate_link', 'cal_amazon_shortcode');
function cal_amazon_shortcode($atts) {
    // デフォルト値を全体設定から取得
    $default_amazon = get_option('cal_default_show_amazon', '1');
    $default_rakuten = get_option('cal_default_show_rakuten', '1');
    $default_yahoo = get_option('cal_default_show_yahoo', '1');
    $default_dmm = get_option('cal_default_show_dmm', '1');
    $default_mercari = get_option('cal_default_show_mercari', '1');
    
    // ショートコード属性
    $atts = shortcode_atts(array(
        'asin' => '',
        'kw' => '',
        'amazon' => $default_amazon,
        'rakuten' => $default_rakuten,
        'yahoo' => $default_yahoo,
        'dmm' => $default_dmm,
        'mercari' => $default_mercari,
    ), $atts);
    
    // 必須パラメータのチェック
    if (empty($atts['asin']) || empty($atts['kw'])) {
        return '<p style="color: red;">エラー: asinとkwは必須です</p>';
    }
    
    // 設定値を取得
    $amazon_id = get_option('cal_amazon_associate_id', '');
    $yahoo_sid = get_option('cal_yahoo_sid', '');
    $yahoo_pid = get_option('cal_yahoo_pid', '');
    $dmm_id = get_option('cal_dmm_affiliate_id', '');
    $mercari_id = get_option('cal_mercari_ambassador_id', '');
    
    // 画像URLを生成
    $image_url = 'https://images-na.ssl-images-amazon.com/images/P/' . esc_attr($atts['asin']) . '.09.LZZZZZZZ';
    
    // Amazonリンク
    $amazon_link = 'https://www.amazon.co.jp/dp/' . esc_attr($atts['asin']);
    if (!empty($amazon_id)) {
        $amazon_link .= '?tag=' . esc_attr($amazon_id);
    }
    
    // 楽天リンク（検索のみ、アフィリエイトなし）
    $rakuten_link = 'https://search.rakuten.co.jp/search/mall/' . rawurlencode($atts['kw']) . '/';
    
    // Yahoo!ショッピングリンク
    $yahoo_link = 'https://shopping.yahoo.co.jp/search?p=' . rawurlencode($atts['kw']);
    if (!empty($yahoo_sid) && !empty($yahoo_pid)) {
        $yahoo_link = 'https://ck.jp.ap.valuecommerce.com/servlet/referral?sid=' . esc_attr($yahoo_sid) . 
                     '&pid=' . esc_attr($yahoo_pid) . 
                     '&vc_url=' . rawurlencode($yahoo_link);
    }
    
    // DMMリンク
    $dmm_link = 'https://www.dmm.com/search/=/searchstr=' . rawurlencode($atts['kw']) . '/';
    if (!empty($dmm_id)) {
        $dmm_link .= 'affiliate_id=' . esc_attr($dmm_id) . '/';
    }
    
    // メルカリリンク（検索結果ページ）
    $mercari_link = 'https://jp.mercari.com/search?keyword=' . rawurlencode($atts['kw']);
    if (!empty($mercari_id)) {
        $mercari_link .= '&afid=' . esc_attr($mercari_id);
    }
    
    // HTMLを生成
    ob_start();
    ?>
    <div class="cal-product-link">
        <div class="cal-product-box">
            <div class="cal-image">
                <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($atts['kw']); ?>">
            </div>
            <div class="cal-info">
                <div class="cal-title"><?php echo esc_html($atts['kw']); ?></div>
                <div class="cal-buttons">
                    <?php if ($atts['amazon'] !== '0'): ?>
                    <a href="<?php echo esc_url($amazon_link); ?>" class="cal-btn cal-btn-amazon" target="_blank" rel="nofollow noopener">Amazon</a>
                    <?php endif; ?>
                    
                    <?php if ($atts['rakuten'] !== '0'): ?>
                    <a href="<?php echo esc_url($rakuten_link); ?>" class="cal-btn cal-btn-rakuten" target="_blank" rel="nofollow noopener">楽天市場</a>
                    <?php endif; ?>
                    
                    <?php if ($atts['yahoo'] !== '0'): ?>
                    <a href="<?php echo esc_url($yahoo_link); ?>" class="cal-btn cal-btn-yahoo" target="_blank" rel="nofollow noopener">Yahoo!</a>
                    <?php endif; ?>
                    
                    <?php if ($atts['dmm'] !== '0'): ?>
                    <a href="<?php echo esc_url($dmm_link); ?>" class="cal-btn cal-btn-dmm" target="_blank" rel="nofollow noopener">DMM</a>
                    <?php endif; ?>
                    
                    <?php if ($atts['mercari'] !== '0'): ?>
                    <a href="<?php echo esc_url($mercari_link); ?>" class="cal-btn cal-btn-mercari" target="_blank" rel="nofollow noopener">メルカリ</a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php
    return ob_get_clean();
}

// CSSの読み込み
add_action('wp_enqueue_scripts', 'cal_enqueue_styles');
function cal_enqueue_styles() {
    // 独立したCSSファイルとして登録
    wp_register_style('cal-affiliate-styles', false);
    wp_enqueue_style('cal-affiliate-styles');
    
    wp_add_inline_style('cal-affiliate-styles', '
        .cal-product-link {
            margin: 20px 0 !important;
        }
        
        .cal-product-box {
            border: 1px solid #ddd !important;
            background: #fff !important;
            border-radius: 4px !important;
            overflow: hidden !important;
            display: flex !important;
            padding: 15px !important;
            gap: 15px !important;
            align-items: flex-start !important;
        }
        
        .cal-image {
            flex-shrink: 0 !important;
            width: 160px !important;
        }
        
        .cal-image img {
            width: 100% !important;
            height: auto !important;
            border: 1px solid #eee !important;
            border-radius: 4px !important;
        }
        
        .cal-info {
            flex: 1 !important;
            display: flex !important;
            flex-direction: column !important;
            gap: 12px !important;
        }
        
        .cal-title {
            font-size: 16px !important;
            font-weight: bold !important;
            line-height: 1.5 !important;
            color: #333 !important;
        }
        
        .cal-buttons {
            display: flex !important;
            gap: 8px !important;
            flex-wrap: wrap !important;
        }
        
        .cal-btn {
            display: inline-flex !important;
            align-items: center !important;
            justify-content: center !important;
            padding: 10px 20px !important;
            border-radius: 4px !important;
            text-decoration: none !important;
            font-weight: bold !important;
            font-size: 14px !important;
            transition: opacity 0.3s !important;
            color: #fff !important;
            min-width: 100px !important;
            border: none !important;
        }
        
        .cal-btn:hover {
            opacity: 0.8 !important;
            color: #fff !important;
        }
        
        .cal-btn-amazon {
            background: #ff9900 !important;
            background-color: #ff9900 !important;
        }
        
        .cal-btn-rakuten {
            background: #bf0000 !important;
            background-color: #bf0000 !important;
        }
        
        .cal-btn-yahoo {
            background: #ff0033 !important;
            background-color: #ff0033 !important;
        }
        
        .cal-btn-dmm {
            background: #0066cc !important;
            background-color: #0066cc !important;
        }
        
        .cal-btn-mercari {
            background: #ff0211 !important;
            background-color: #ff0211 !important;
        }
        
        @media screen and (max-width: 768px) {
            .cal-product-box {
                flex-direction: column !important;
                align-items: center !important;
                text-align: center !important;
            }
            
            .cal-image {
                width: 120px !important;
            }
            
            .cal-buttons {
                justify-content: center !important;
                width: 100% !important;
            }
            
            .cal-btn {
                flex: 1 !important;
                min-width: 80px !important;
            }
        }
        
        @media screen and (max-width: 480px) {
            .cal-buttons {
                flex-direction: column !important;
            }
            
            .cal-btn {
                width: 100% !important;
            }
        }
    ');
}
